<?php

uses(\Stillat\BladeParser\Tests\ParserTestCase::class);
use Stillat\BladeParser\Document\Document;
use Stillat\BladeParser\Validation\Validators\RequiresOpenValidator;

test('requires open validator detects issues', function () {
    $message = 'Missing required opening directive for [@endfor]';
    $results = Document::fromText('@endfor')
        ->addValidator(new RequiresOpenValidator)
        ->validate()->getValidationErrors();

    expect($results)->toHaveCount(1);
    expect($results[0]->message)->toBe($message);
});

test('requires open validator does not detect issues', function () {
    $template = <<<'BLADE'
@for

@endfor
BLADE;
    $results = Document::fromText($template)
        ->addValidator(new RequiresOpenValidator)
        ->validate()->getValidationErrors();

    expect($results)->toHaveCount(0);
});
