<?php

namespace Statamic\Dictionaries;

class Currencies extends BasicDictionary
{
    protected string $valueKey = 'code';
    protected array $keywords = ['currencies', 'currency', 'money', 'dollar'];

    protected function getItemLabel(array $item): string
    {
        return "{$item['name']} ({$item['code']})";
    }

    protected function getItems(): array
    {
        return [
            ['code' => 'AED', 'name' => __('statamic::dictionary-currencies.AED'), 'symbol' => 'د.إ.‏', 'decimals' => 2],
            ['code' => 'AFN', 'name' => __('statamic::dictionary-currencies.AFN'), 'symbol' => '؋', 'decimals' => 0],
            ['code' => 'ALL', 'name' => __('statamic::dictionary-currencies.ALL'), 'symbol' => 'Lek', 'decimals' => 0],
            ['code' => 'AMD', 'name' => __('statamic::dictionary-currencies.AMD'), 'symbol' => 'դր.', 'decimals' => 0],
            ['code' => 'ARS', 'name' => __('statamic::dictionary-currencies.ARS'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'AUD', 'name' => __('statamic::dictionary-currencies.AUD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'AZN', 'name' => __('statamic::dictionary-currencies.AZN'), 'symbol' => 'ман.', 'decimals' => 2],
            ['code' => 'BAM', 'name' => __('statamic::dictionary-currencies.BAM'), 'symbol' => 'KM', 'decimals' => 2],
            ['code' => 'BDT', 'name' => __('statamic::dictionary-currencies.BDT'), 'symbol' => '৳', 'decimals' => 2],
            ['code' => 'BGN', 'name' => __('statamic::dictionary-currencies.BGN'), 'symbol' => 'лв.', 'decimals' => 2],
            ['code' => 'BHD', 'name' => __('statamic::dictionary-currencies.BHD'), 'symbol' => 'د.ب.‏', 'decimals' => 3],
            ['code' => 'BIF', 'name' => __('statamic::dictionary-currencies.BIF'), 'symbol' => 'FBu', 'decimals' => 0],
            ['code' => 'BND', 'name' => __('statamic::dictionary-currencies.BND'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'BOB', 'name' => __('statamic::dictionary-currencies.BOB'), 'symbol' => 'Bs', 'decimals' => 2],
            ['code' => 'BRL', 'name' => __('statamic::dictionary-currencies.BRL'), 'symbol' => 'R$', 'decimals' => 2],
            ['code' => 'BWP', 'name' => __('statamic::dictionary-currencies.BWP'), 'symbol' => 'P', 'decimals' => 2],
            ['code' => 'BYN', 'name' => __('statamic::dictionary-currencies.BYN'), 'symbol' => 'руб.', 'decimals' => 2],
            ['code' => 'BZD', 'name' => __('statamic::dictionary-currencies.BZD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'CAD', 'name' => __('statamic::dictionary-currencies.CAD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'CDF', 'name' => __('statamic::dictionary-currencies.CDF'), 'symbol' => 'FrCD', 'decimals' => 2],
            ['code' => 'CHF', 'name' => __('statamic::dictionary-currencies.CHF'), 'symbol' => 'CHF', 'decimals' => 2],
            ['code' => 'CLP', 'name' => __('statamic::dictionary-currencies.CLP'), 'symbol' => '$', 'decimals' => 0],
            ['code' => 'CNY', 'name' => __('statamic::dictionary-currencies.CNY'), 'symbol' => 'CN¥', 'decimals' => 2],
            ['code' => 'COP', 'name' => __('statamic::dictionary-currencies.COP'), 'symbol' => '$', 'decimals' => 0],
            ['code' => 'CRC', 'name' => __('statamic::dictionary-currencies.CRC'), 'symbol' => '₡', 'decimals' => 0],
            ['code' => 'CVE', 'name' => __('statamic::dictionary-currencies.CVE'), 'symbol' => 'CV$', 'decimals' => 2],
            ['code' => 'CZK', 'name' => __('statamic::dictionary-currencies.CZK'), 'symbol' => 'Kč', 'decimals' => 2],
            ['code' => 'DJF', 'name' => __('statamic::dictionary-currencies.DJF'), 'symbol' => 'Fdj', 'decimals' => 0],
            ['code' => 'DKK', 'name' => __('statamic::dictionary-currencies.DKK'), 'symbol' => 'kr', 'decimals' => 2],
            ['code' => 'DOP', 'name' => __('statamic::dictionary-currencies.DOP'), 'symbol' => 'RD$', 'decimals' => 2],
            ['code' => 'DZD', 'name' => __('statamic::dictionary-currencies.DZD'), 'symbol' => 'د.ج.‏', 'decimals' => 2],
            ['code' => 'EEK', 'name' => __('statamic::dictionary-currencies.EEK'), 'symbol' => 'kr', 'decimals' => 2],
            ['code' => 'EGP', 'name' => __('statamic::dictionary-currencies.EGP'), 'symbol' => 'ج.م.‏', 'decimals' => 2],
            ['code' => 'ERN', 'name' => __('statamic::dictionary-currencies.ERN'), 'symbol' => 'Nfk', 'decimals' => 2],
            ['code' => 'ETB', 'name' => __('statamic::dictionary-currencies.ETB'), 'symbol' => 'Br', 'decimals' => 2],
            ['code' => 'EUR', 'name' => __('statamic::dictionary-currencies.EUR'), 'symbol' => '€', 'decimals' => 2],
            ['code' => 'GBP', 'name' => __('statamic::dictionary-currencies.GBP'), 'symbol' => '£', 'decimals' => 2],
            ['code' => 'GEL', 'name' => __('statamic::dictionary-currencies.GEL'), 'symbol' => 'GEL', 'decimals' => 2],
            ['code' => 'GHS', 'name' => __('statamic::dictionary-currencies.GHS'), 'symbol' => 'GH₵', 'decimals' => 2],
            ['code' => 'GNF', 'name' => __('statamic::dictionary-currencies.GNF'), 'symbol' => 'FG', 'decimals' => 0],
            ['code' => 'GTQ', 'name' => __('statamic::dictionary-currencies.GTQ'), 'symbol' => 'Q', 'decimals' => 2],
            ['code' => 'HKD', 'name' => __('statamic::dictionary-currencies.HKD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'HNL', 'name' => __('statamic::dictionary-currencies.HNL'), 'symbol' => 'L', 'decimals' => 2],
            ['code' => 'HRK', 'name' => __('statamic::dictionary-currencies.HRK'), 'symbol' => 'kn', 'decimals' => 2],
            ['code' => 'HUF', 'name' => __('statamic::dictionary-currencies.HUF'), 'symbol' => 'Ft', 'decimals' => 0],
            ['code' => 'IDR', 'name' => __('statamic::dictionary-currencies.IDR'), 'symbol' => 'Rp', 'decimals' => 0],
            ['code' => 'ILS', 'name' => __('statamic::dictionary-currencies.ILS'), 'symbol' => '₪', 'decimals' => 2],
            ['code' => 'INR', 'name' => __('statamic::dictionary-currencies.INR'), 'symbol' => 'টকা', 'decimals' => 2],
            ['code' => 'IQD', 'name' => __('statamic::dictionary-currencies.IQD'), 'symbol' => 'د.ع.‏', 'decimals' => 0],
            ['code' => 'IRR', 'name' => __('statamic::dictionary-currencies.IRR'), 'symbol' => '﷼', 'decimals' => 0],
            ['code' => 'ISK', 'name' => __('statamic::dictionary-currencies.ISK'), 'symbol' => 'kr', 'decimals' => 0],
            ['code' => 'JMD', 'name' => __('statamic::dictionary-currencies.JMD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'JOD', 'name' => __('statamic::dictionary-currencies.JOD'), 'symbol' => 'د.أ.‏', 'decimals' => 3],
            ['code' => 'JPY', 'name' => __('statamic::dictionary-currencies.JPY'), 'symbol' => '￥', 'decimals' => 0],
            ['code' => 'KES', 'name' => __('statamic::dictionary-currencies.KES'), 'symbol' => 'Ksh', 'decimals' => 2],
            ['code' => 'KHR', 'name' => __('statamic::dictionary-currencies.KHR'), 'symbol' => '៛', 'decimals' => 2],
            ['code' => 'KMF', 'name' => __('statamic::dictionary-currencies.KMF'), 'symbol' => 'FC', 'decimals' => 0],
            ['code' => 'KRW', 'name' => __('statamic::dictionary-currencies.KRW'), 'symbol' => '₩', 'decimals' => 0],
            ['code' => 'KWD', 'name' => __('statamic::dictionary-currencies.KWD'), 'symbol' => 'د.ك.‏', 'decimals' => 3],
            ['code' => 'KZT', 'name' => __('statamic::dictionary-currencies.KZT'), 'symbol' => 'тңг.', 'decimals' => 2],
            ['code' => 'LBP', 'name' => __('statamic::dictionary-currencies.LBP'), 'symbol' => 'ل.ل.‏', 'decimals' => 0],
            ['code' => 'LKR', 'name' => __('statamic::dictionary-currencies.LKR'), 'symbol' => 'SL Re', 'decimals' => 2],
            ['code' => 'LTL', 'name' => __('statamic::dictionary-currencies.LTL'), 'symbol' => 'Lt', 'decimals' => 2],
            ['code' => 'LVL', 'name' => __('statamic::dictionary-currencies.LVL'), 'symbol' => 'Ls', 'decimals' => 2],
            ['code' => 'LYD', 'name' => __('statamic::dictionary-currencies.LYD'), 'symbol' => 'د.ل.‏', 'decimals' => 3],
            ['code' => 'MAD', 'name' => __('statamic::dictionary-currencies.MAD'), 'symbol' => 'د.م.‏', 'decimals' => 2],
            ['code' => 'MDL', 'name' => __('statamic::dictionary-currencies.MDL'), 'symbol' => 'MDL', 'decimals' => 2],
            ['code' => 'MGA', 'name' => __('statamic::dictionary-currencies.MGA'), 'symbol' => 'MGA', 'decimals' => 0],
            ['code' => 'MKD', 'name' => __('statamic::dictionary-currencies.MKD'), 'symbol' => 'MKD', 'decimals' => 2],
            ['code' => 'MMK', 'name' => __('statamic::dictionary-currencies.MMK'), 'symbol' => 'K', 'decimals' => 0],
            ['code' => 'MOP', 'name' => __('statamic::dictionary-currencies.MOP'), 'symbol' => 'MOP$', 'decimals' => 2],
            ['code' => 'MUR', 'name' => __('statamic::dictionary-currencies.MUR'), 'symbol' => 'MURs', 'decimals' => 0],
            ['code' => 'MXN', 'name' => __('statamic::dictionary-currencies.MXN'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'MYR', 'name' => __('statamic::dictionary-currencies.MYR'), 'symbol' => 'RM', 'decimals' => 2],
            ['code' => 'MZN', 'name' => __('statamic::dictionary-currencies.MZN'), 'symbol' => 'MTn', 'decimals' => 2],
            ['code' => 'NAD', 'name' => __('statamic::dictionary-currencies.NAD'), 'symbol' => 'N$', 'decimals' => 2],
            ['code' => 'NGN', 'name' => __('statamic::dictionary-currencies.NGN'), 'symbol' => '₦', 'decimals' => 2],
            ['code' => 'NIO', 'name' => __('statamic::dictionary-currencies.NIO'), 'symbol' => 'C$', 'decimals' => 2],
            ['code' => 'NOK', 'name' => __('statamic::dictionary-currencies.NOK'), 'symbol' => 'kr', 'decimals' => 2],
            ['code' => 'NPR', 'name' => __('statamic::dictionary-currencies.NPR'), 'symbol' => 'नेरू', 'decimals' => 2],
            ['code' => 'NZD', 'name' => __('statamic::dictionary-currencies.NZD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'OMR', 'name' => __('statamic::dictionary-currencies.OMR'), 'symbol' => 'ر.ع.‏', 'decimals' => 3],
            ['code' => 'PAB', 'name' => __('statamic::dictionary-currencies.PAB'), 'symbol' => 'B/.', 'decimals' => 2],
            ['code' => 'PEN', 'name' => __('statamic::dictionary-currencies.PEN'), 'symbol' => 'S/.', 'decimals' => 2],
            ['code' => 'PHP', 'name' => __('statamic::dictionary-currencies.PHP'), 'symbol' => '₱', 'decimals' => 2],
            ['code' => 'PKR', 'name' => __('statamic::dictionary-currencies.PKR'), 'symbol' => '₨', 'decimals' => 0],
            ['code' => 'PLN', 'name' => __('statamic::dictionary-currencies.PLN'), 'symbol' => 'zł', 'decimals' => 2],
            ['code' => 'PYG', 'name' => __('statamic::dictionary-currencies.PYG'), 'symbol' => '₲', 'decimals' => 0],
            ['code' => 'QAR', 'name' => __('statamic::dictionary-currencies.QAR'), 'symbol' => 'ر.ق.‏', 'decimals' => 2],
            ['code' => 'RON', 'name' => __('statamic::dictionary-currencies.RON'), 'symbol' => 'RON', 'decimals' => 2],
            ['code' => 'RSD', 'name' => __('statamic::dictionary-currencies.RSD'), 'symbol' => 'дин.', 'decimals' => 0],
            ['code' => 'RUB', 'name' => __('statamic::dictionary-currencies.RUB'), 'symbol' => '₽.', 'decimals' => 2],
            ['code' => 'RWF', 'name' => __('statamic::dictionary-currencies.RWF'), 'symbol' => 'FR', 'decimals' => 0],
            ['code' => 'SAR', 'name' => __('statamic::dictionary-currencies.SAR'), 'symbol' => 'ر.س.‏', 'decimals' => 2],
            ['code' => 'SDG', 'name' => __('statamic::dictionary-currencies.SDG'), 'symbol' => 'SDG', 'decimals' => 2],
            ['code' => 'SEK', 'name' => __('statamic::dictionary-currencies.SEK'), 'symbol' => 'kr', 'decimals' => 2],
            ['code' => 'SGD', 'name' => __('statamic::dictionary-currencies.SGD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'SOS', 'name' => __('statamic::dictionary-currencies.SOS'), 'symbol' => 'Ssh', 'decimals' => 0],
            ['code' => 'SYP', 'name' => __('statamic::dictionary-currencies.SYP'), 'symbol' => 'ل.س.‏', 'decimals' => 0],
            ['code' => 'THB', 'name' => __('statamic::dictionary-currencies.THB'), 'symbol' => '฿', 'decimals' => 2],
            ['code' => 'TND', 'name' => __('statamic::dictionary-currencies.TND'), 'symbol' => 'د.ت.‏', 'decimals' => 3],
            ['code' => 'TOP', 'name' => __('statamic::dictionary-currencies.TOP'), 'symbol' => 'T$', 'decimals' => 2],
            ['code' => 'TRY', 'name' => __('statamic::dictionary-currencies.TRY'), 'symbol' => 'TL', 'decimals' => 2],
            ['code' => 'TTD', 'name' => __('statamic::dictionary-currencies.TTD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'TWD', 'name' => __('statamic::dictionary-currencies.TWD'), 'symbol' => 'NT$', 'decimals' => 2],
            ['code' => 'TZS', 'name' => __('statamic::dictionary-currencies.TZS'), 'symbol' => 'TSh', 'decimals' => 0],
            ['code' => 'UAH', 'name' => __('statamic::dictionary-currencies.UAH'), 'symbol' => '₴', 'decimals' => 2],
            ['code' => 'UGX', 'name' => __('statamic::dictionary-currencies.UGX'), 'symbol' => 'USh', 'decimals' => 0],
            ['code' => 'USD', 'name' => __('statamic::dictionary-currencies.USD'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'UYU', 'name' => __('statamic::dictionary-currencies.UYU'), 'symbol' => '$', 'decimals' => 2],
            ['code' => 'UZS', 'name' => __('statamic::dictionary-currencies.UZS'), 'symbol' => 'UZS', 'decimals' => 0],
            ['code' => 'VEF', 'name' => __('statamic::dictionary-currencies.VEF'), 'symbol' => 'Bs.F.', 'decimals' => 2],
            ['code' => 'VND', 'name' => __('statamic::dictionary-currencies.VND'), 'symbol' => '₫', 'decimals' => 0],
            ['code' => 'XAF', 'name' => __('statamic::dictionary-currencies.XAF'), 'symbol' => 'FCFA', 'decimals' => 0],
            ['code' => 'XOF', 'name' => __('statamic::dictionary-currencies.XOF'), 'symbol' => 'CFA', 'decimals' => 0],
            ['code' => 'YER', 'name' => __('statamic::dictionary-currencies.YER'), 'symbol' => 'ر.ي.‏', 'decimals' => 0],
            ['code' => 'ZAR', 'name' => __('statamic::dictionary-currencies.ZAR'), 'symbol' => 'R', 'decimals' => 2],
            ['code' => 'ZMK', 'name' => __('statamic::dictionary-currencies.ZMK'), 'symbol' => 'ZK', 'decimals' => 0],
            ['code' => 'ZWL', 'name' => __('statamic::dictionary-currencies.ZWL'), 'symbol' => 'ZWL$', 'decimals' => 0],
        ];
    }
}
