<?php

return [

    'cheatsheet' => '
<p>Markdown è un linguaggio di marcatura per scrittori del web. Permette di scrivere dei testi utilizzando una sintassi facili da leggere e da scrivere, convertendo il codice in strutture HTML semanticamente corrette.</p>

<h3>Intestazioni</h3>
<pre class="language-markdown"><code># Questo è un h1
## Questo è un h2
### Questo è un h3, e così via.
</code></pre>

<h3>Grassetto &amp; Corsivo</h3>
<pre class="language-markdown"><code>Puoi scrivere del testo in *corsivo*, **grassetto** o _**entrambi**_.</code></pre>

<h3>Link</h3>
<pre class="language-markdown"><code>Questo è un [esempio di link](http://example.com).</code></pre>

<h3>Codice</h3>
<p>
Racchiudi il tuo codice tra 3 apici inversi (<code>```</code>).
</p>

<pre class="language-markdown"><code>```
this: is some yaml
```</code></pre>

<p>Puoi aggiunge anche del codice in linea racchiudendolo tra un <code>`</code> singolo apice inverso.

<h3>Citazioni</h3>

<p>Crea un blocco citazione iniziando il tuo testo con <code>> </code>.</p>

<pre class="language-markdown"><code>> Questo è un blocco citazione.</code></pre>

<h3>Immagini</h3>
<pre class="language-markdown"><code>![testo alternativo](http://example.com/image.jpg)</code></pre>

<h3>Liste non ordinate</h3>
<pre class="language-markdown"><code>- Bacon
- Steak
- Beer</code></pre>

<h3>Liste ordinate</h3>
<pre class="language-markdown"><code>1. Eat
2. Drink
3. Be merry</code></pre>

<h3>Tabelle</h3>

<pre class="language-markdown"><code>Prima intestazione  | Seconda intestazione
------------- | -------------
Contenuto cella  | Contenuto cella
Contenuto cella  | Contenuto cella</code></pre>',

];
